package com.agilex.healthcare.directscheduling.mdws.translator;

import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.HospitalLocationTO;
import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray;
import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedText;
import com.agilex.healthcare.directscheduling.validator.MdwsResponseException;
import gov.va.vamf.scheduling.direct.domain.ClinicProfile;

import java.util.List;

public class ClinicProfileTranslator {
    public ClinicProfile translate(TaggedHospitalLocationArray taggedHospitalLocationArray, String siteCode, String clinicId) {
        if (taggedHospitalLocationArray == null || taggedHospitalLocationArray.getCount() <= 0) {
            throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_DATA_RETURNED, "taggedHospitalLocationArray is null");
        }
        if (taggedHospitalLocationArray.getFault() != null)
            throw new MdwsResponseException(taggedHospitalLocationArray.getFault());

        List<HospitalLocationTO> hospitalLocationToList = taggedHospitalLocationArray.getLocations().getHospitalLocationTO();
        if (hospitalLocationToList == null || hospitalLocationToList.isEmpty()) {
            throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_DATA_RETURNED, "hospitalLocationToList is empty or null");
        }

        HospitalLocationTO hospitalLocationTO = hospitalLocationToList.get(0);
        ClinicProfile clinicProfile = new ClinicProfile();
        clinicProfile.setSiteCode(siteCode);
        clinicProfile.setClinicId(clinicId);
        clinicProfile.setClinicName(hospitalLocationTO.getName());
        clinicProfile.setAppointmentLength(hospitalLocationTO.getAppointmentLength());
        clinicProfile.setDisplayStartTime(hospitalLocationTO.getClinicDisplayStartTime());
        clinicProfile.setDisplayIncrements(hospitalLocationTO.getDisplayIncrements());
        clinicProfile.setAskForCheckIn(hospitalLocationTO.isAskForCheckIn());
        clinicProfile.setMaxOverbooksPerDay(hospitalLocationTO.getMaxOverbooksPerDay());

        TaggedText stopCodeTag = hospitalLocationTO.getStopCode();
        TaggedText creditStopCodeTag = hospitalLocationTO.getCreditStopCode();
        TaggedText specialtyTag = hospitalLocationTO.getSpecialty();

        if (stopCodeTag != null) {
            if (stopCodeTag.getFault() != null) throw new MdwsResponseException(stopCodeTag.getFault());
            String stopCode = stopCodeTag.getTag();
            clinicProfile.setStopCode(stopCode);
        }
        if (creditStopCodeTag != null) {
            if (creditStopCodeTag.getFault() != null) throw new MdwsResponseException(creditStopCodeTag.getFault());
            String creditStopCode = creditStopCodeTag.getTag();
            clinicProfile.setCreditCode(creditStopCode);
        }
        if (specialtyTag != null) {
            if (specialtyTag.getFault() != null) throw new MdwsResponseException(specialtyTag.getFault());
            String specialty = specialtyTag.getTag();
            clinicProfile.setSpecialty(specialty);
        }

        return clinicProfile;
    }
}
